<?php
require "OneDriveClient.php";
require "FileManagerUI.php";

/******************************************************
 * CONFIG
 ******************************************************/
$tenantId  = "6ea6bcac-e308-4c86-9487-7bb23e54210b";
$clientId  = "7aad2986-6cef-4058-ab1a-3163f6e34c25";
$clientSecret = "qBF8Q~MTu7zhR7CA-c6YLxK6oJg8wjJ1vZ_weaZa";
$driveId   = "b!CNIQy0CadkK3fkUsDTWMLAg7CrX7lwdErcLSarTa1UhSO4fD47MpSrGokFdsKDAs";

$rootFolderId = "01FLON3H3FSFIDJI5DDRFZL6LTXC73YNTP";

$client = new OneDriveClient($tenantId, $clientId, $clientSecret, $driveId);

/******************************************************
 * FOLDER ACTUAL
 ******************************************************/
$currentFolderId = $_GET["folder"] ?? $rootFolderId;

/******************************************************
 * ACCIONES POST
 ******************************************************/
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $action = $_POST["action"];

    if ($action === "upload") {
        $client->upload($currentFolderId, $_FILES["archivo"]["tmp_name"], $_FILES["archivo"]["name"]);
    }

    if ($action === "create_folder") {
        $client->createFolder($currentFolderId, $_POST["folder_name"]);
    }

    if ($action === "rename") {
        $client->rename($_POST["item_id"], $_POST["new_name"]);
    }

    if ($action === "delete") {
        $client->delete($_POST["item_id"]);
    }

    header("Location: ?folder=" . $currentFolderId);
    exit;
}

/******************************************************
 * OBTENER BREADCRUMB
 ******************************************************/
$breadcrumb = $client->buildBreadcrumb($currentFolderId, $rootFolderId);

/******************************************************
 * LISTA DE ARCHIVOS/CARPETAS
 ******************************************************/
$items = $client->listChildren($currentFolderId);

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>OneDrive File Manager</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="bg-light">

<div class="container py-4">

    <h2>📁 Gestor OneDrive</h2>

    <?php FileManagerUI::renderBreadcrumb($breadcrumb, $currentFolderId); ?>

    <?php FileManagerUI::renderForms($currentFolderId); ?>

    <?php FileManagerUI::renderList($items); ?>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
